import numpy as N
import re
import sys
import os
from uncertainties import ufloat
from uncertainties.umath import * 

def proces_raw_results(rawfile, savedir, rho_mirror, dni):

    '''
    rawfile - the 'simul' file generated by SOLSTICE
    savedir - the directry for saving the organised results
    '''
    with open(rawfile) as f:
        content = f.read().splitlines()
        # content is a list with lots of string
    f.close()

    results=N.array([])

    # sun direction
    sun=re.findall("[-+]?\d*\.\d+|\d+", content[0])
    azimuth=sun[0]
    elevation=sun[1]

    # Global results
    line=map(float, content[1].split(' '))
    num_res=int(line[0]) # number of global results
    num_rec=int(line[1]) # number of receivers
    num_hst=int(line[2]) # number of heliostats
    num_rays=line[3] # number of rays


    potential=map(float, content[2].split(' '))[0] #W
    potential_err=map(float, content[2].split(' '))[1]

    absorbed=map(float, content[3].split(' '))[0]
    absorbed_err=map(float, content[3].split(' '))[1]    

    Fcos=map(float, content[4].split(' '))[0]
    Fcos_err=map(float, content[4].split(' '))[1]  

    shadow_loss=map(float, content[5].split(' '))[0]
    shadow_err=map(float, content[5].split(' '))[1]    
  
    missing_loss=map(float, content[6].split(' '))[0]
    missing_err=map(float, content[6].split(' '))[1] 

    material_loss=map(float, content[7].split(' '))[0]
    material_err=map(float, content[7].split(' '))[1]    
   
    atmospheric_loss=map(float, content[8].split(' '))[0]
    atmospheric_err=map(float, content[8].split(' '))[1]  


    # Target (receiver)
    target=content[num_res+2].split()
    # 0 receiver name
    # 1 - 2 id and area
    # 3 - 24 (total 22) front
    # 25- 46 (total 22) back 
    rec_area=float(target[2]) # m2  

    rec_front_income=float(target[3])
    rec_front_income_err=float(target[4])
    #rec_no_material_loss=float(target[5])
    #rec_no_material_loss_err=float(target[6])
    #rec_no_atmo_loss=float(target[7])
    #rec_no_atmo_loss_err=float(target[8])
    #rec_material_loss=float(target[9])
    #rec_material_loss_err=float(target[10])
    rec_front_absorbed=float(target[13])
    rec_front_absorbed_err=float(target[14])
    rec_front_eff=float(target[23])
    rec_front_eff_err=float(target[24])

    rec_back_income=float(target[25])
    rec_back_income_err=float(target[26])
    rec_back_absorbed=float(target[35])
    rec_back_absorbed_err=float(target[36])
    rec_back_eff=float(target[-2])
    rec_back_eff_err=float(target[-1])

    if num_rec>1:
        #Virtual target
        virtual=content[num_res+3].split()
        vir_area=float(virtual[2])
        vir_income=float(virtual[3])
        vir_income_err=float(virtual[4])
      
    raw_res=N.array(['name','value', 'error',
                     'sun_azimuth', azimuth,'',
                     'sun_elevation', elevation, '',
                     'num hst', num_hst,'', 
                     'num rays',num_rays, '',
                     'potential flux', potential, potential_err,
                     'absorbed flux', absorbed, absorbed_err, 
                     'Cosine factor', Fcos, Fcos_err, 
                     'shadow loss', shadow_loss, shadow_err, 
                     'Mising loss', missing_loss, missing_err, 
                     'materials loss', material_loss, material_err,
                     'atomospheric loss', atmospheric_loss, atmospheric_err, 
                     '','','',
                     'Target', '','',
                     'area', rec_area, '',
                     'front income flux', rec_front_income, rec_front_income_err, 
                     'back income flux', rec_back_income, rec_back_income_err, 
                     'front absorbed flux', rec_front_absorbed, rec_front_absorbed_err, 
                     'back absorbed flux', rec_back_absorbed, rec_back_absorbed_err, 
                     'front efficiency', rec_front_eff, rec_front_eff_err,
                     'back efficiency', rec_back_eff, rec_back_eff_err,
                      '','','',
                     'Virtual plane','','',
                     'area', vir_area, '',
                     'income flux', vir_income,vir_income_err])
    
    raw_res=raw_res.reshape(len(raw_res)/3, 3)

    N.savetxt(savedir+'/results-raw.csv', raw_res, fmt='%s', delimiter=',')


    Qtotal=ufloat(potential, 0)
    Fcos=ufloat(Fcos,Fcos_err) 
    Qcos=Qtotal*(1.-Fcos)
    Qshade=ufloat(shadow_loss,shadow_err)
    Qfield_abs=(Qtotal-Qcos-Qshade)*(1.-float(rho_mirror))
    Qatm=ufloat(atmospheric_loss, atmospheric_err)
    Qspil=ufloat(vir_income,vir_income_err)
    Qabs=ufloat(absorbed, absorbed_err)
    Qrefl=ufloat(rec_front_income,rec_front_income_err)+ufloat(rec_back_income,rec_back_income_err)-Qabs
    Qblock=Qtotal-Qcos-Qshade-Qfield_abs-Qspil-Qabs-Qrefl-Qatm
   
    organised=N.array(['Name', 'Value', '+/-Error', 
                       'Qall (kW)', Qtotal.n/1000., Qtotal.s/1000., 
                       'Qcos (kW)', Qcos.n/1000.,Qcos.s/1000.,
                       'Qshad (kW)', Qshade.n/1000., Qshade.s/1000.,
                       'Qfield_abs (kW)', Qfield_abs.n/1000., Qfield_abs.s/1000., 
                       'Qblcok (kW)', Qblock.n/1000.,  Qblock.s/1000., 
                       'Qatm (kW)',Qatm.n/1000., Qatm.s/1000., 
                       'Qspil (kW)', Qspil.n/1000., Qspil.s/1000., 
                       'Qrefl (kW)', Qrefl.n/1000.,Qrefl.s/1000., 
                       'Qabs (kW)', Qabs.n/1000., Qabs.s/1000., 
                       'rays', num_rays,'-'])
    N.savetxt(savedir+'/results-formatted.csv', organised.reshape(len(organised)/3,3), fmt='%s', delimiter=',')

    efficiency_total=Qabs/Qtotal
    print ''
    print 'Total     efficiency:', efficiency_total
    print 'Number of heliostats:', num_hst


    # per heliostat results, and
    # per receiver per heliostat results
    heliostats=N.zeros((num_hst+1, 3)).astype(str)
    heliostats[:, :]='-'
    heliostats[0]=N.array(['hst_idx', 'total', 'rec_in']) 

    for i in xrange(num_hst):
        l1=2+num_res+num_rec+i # the line number of the per heliostat result
        per_hst=content[l1].split()

        hst_idx=re.findall("[-+]?\d*\.\d+|\d+", per_hst[0] ) 
        hst_area=per_hst[2]
        hst_tot=float(hst_area)*dni


        # per heliostat per receiver
        l2=2+num_res+num_rec+num_hst+i  
        per_hst=content[l2].split()   
        # ref: https://www.meso-star.com/projects/solstice/man/man5/solstice-output.5.html
        rec_in=float(per_hst[2])+float(per_hst[22])        # flux that reaches the receiver side, front+back

        heliostats[i+1,0]=hst_idx[0]
        heliostats[i+1,1]=hst_tot
        heliostats[i+1,2]=rec_in
    N.savetxt(savedir+'/results-heliostats.csv', heliostats, fmt='%s', delimiter=',')

    performance_hst=heliostats[1:].astype(float)
    performance_hst=performance_hst[performance_hst[:,0].argsort()]

    return Qabs.n, Qtotal.n, performance_hst[:,1:]
    
  


if __name__=='__main__':
    
    proces_raw_results(sys.argv[1], sys.argv[2], sys.argv[3])


